/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230509
* Description : 设置配置字RSEL=HIGH(RSEL=0)   0：上拉电阻：100K  下拉电阻：300K;PA口和PB口接VDD,通过万用表查看对应IO的电流，根据公式R=U/I算出电阻
* Note		  :
********************************************************************************/
/*********************************************************************************************
*
* _FINTOSC_DIV1   :  内部RC振荡器频率选择
* _DBG_OFF        :  DEBUG模式使能位
* _LVREN_ON       :  LVR使能
* _LVR24V         :  LVR的电压选择为2.4V
* _FLASH_CP1_OFF  :  1K~2K*16 FLASH CP保护
* _FLASH_CP0_OFF  :  0~1K*16 FLASH CP保护
* _IDIS_OFF	      :  模拟IO打开，数据读取控制位
* _CKSUM_OFF      :  校验使能位
* _CBP_OFF	      :  代码保护选择位
* _RESETE_OFF     :  外部复位使能
* _RSEL		      :  端口上下拉电阻选择
* _STV_ON		  :  堆栈溢出复位
* _PSUT_2		  :  上电复位时间选择
* _FCPU_4T        :  指令周期选择4T
* _WDTE_OFF       :  看门狗使能
* _TWDT_000       :  看门狗溢出时间选择
* _OSCM_HIRC_16M  :  系统时钟选择高速时钟
* _MTPDIS_OFF     :  SWD模式下读FALSH控制
* _ADCSP_ON	      :	 ADC采集速度选择
*
*
************************************************************************************************/

#include "AD18F08.h"

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_HIGH_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L     & _TWDT_100_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                                        );


void main(void)
{
    TRISA   = 0xFF; //设置PA口为输入
    TRISB   = 0xFF; //设置PB口为输入

    PAPU    = 0x00; //打开PA口的上拉
    PBPU    = 0x00;	//打开PB口的上拉

    PAPD    = 0xFF;//关闭PA口的下拉
    PBPD    = 0xFF;//关闭PB口的下拉

    PAOD    = 0x00; //关闭PA口的开漏
    PBOD    = 0x00; //关闭PB口的开漏

	ANASEL0 = 0x00; //关闭PA口的模拟通道
	ANASEL1 = 0x00; //关闭PB口的模拟通道

	PORTA   = 0x00; //PA口输出低电平
	PORTB   = 0x00; //PB口输出低电平

	while(1);


}
//高优先级中断服务函数

void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断



}

//低优先级中断服务函数

void interrupt low_priority ISR_l (void)
{


}



